﻿var shifts = {
    context: $(".v-callbacks-shifts"),
    datatable: null,
    inChange: false,
    initializeDataTable: function () {
        this.datatable = $(".h-shifts-table", this.context).a4datatable({
            //advancedFilter: true,
            displaySearchBox: false,
            height: "full",
            multiEdit: true,
            ajaxAction: a4.getProjectAction("GetShifts", "CallBacks"),
            columns: [
                { "Title": resources.Number, "Name": "Id", "Key": true },
                { "Title": resources.WeekDay, "Data": "WeekDayEnum", "Name": "WeekDay", "EnumType": "DayOfWeek", "Type": "enum", "Editable": { "Required": true } },
                { "Title": resources.Start, "Data": "StartTimeFormatted", "Name": "StartTime", "Type": "time", "Editable": { "Required": true } },
                { "Title": resources.End, "Data": "EndTimeFormatted", "Name": "EndTime", "Type": "time", "Editable": { "Required": true } }
            ],
            draw: function (event, data) {

            },
            stateKey: "CallbackShifts",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        shifts.deleteShifts([row.Id]);
                        break;
                    case "properties":
                        shifts.editShifts(row.Id);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    shifts.deleteShifts(ids);
                }
            },
            rowUpdated: function (even, data) {
                var fieldName = data.fieldName;

                switch (fieldName) {
                    case "WeekDayDescription":
                        shifts.inChange = true;
                        var dayId = (data.data.WeekDayDescription) ? parseInt(data.data.WeekDayDescription) + 1 : 1;
                        shifts.datatable.a4datatable("updateItem", data.index, { WeekDayDescription: data.data.WeekDayDescription, WeekDay: dayId });
                        break;

                    default:
                        shifts.inChange = false;
                        break;
                }
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getProjectAction("UpdateShifts", "CallBacks"), { shifts: data.rows }, function () {
                    data.multiEditSaveCallback();
                });
            }
        });
    },
    bindEvents: function () {
        shifts.context.on("click", ".h-add-shifts", function () {
            modalDialog.showWindow(a4.getProjectAction("EditShift", "CallBacks"), 400, 600, { afterClose: function () { shifts.refreshContent(); } });
        });

        shifts.context.on("click", ".h-copyShifts", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("CopyShifts", "CallBacks"), { sourceProjectId: sourceProjectId },
                function (result) {
                    shifts.refreshContent();
                });
            }, resources.CopyShiftFrom, false, confirmCopyShiftResources);
        });

        shifts.context.on("click", ".h-settings", function () {
            modalDialog.showWindow(a4.getProjectAction("ShiftSettings", "CallBacks"), 250, 600, { afterClose: function () { window.location.reload(); } });
        });
    },
    deleteShifts: function (shiftIds) {
        modalDialog.showConfirmDelete(confirmDeleteShiftsResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteShifts", "CallBacks"), { shiftIds: shiftIds },
                function (result) {
                    shifts.refreshContent();
                });
        }, shiftIds.length);
    },
    editShifts: function (shiftId) {
        modalDialog.showWindow(a4.getProjectAction("EditShift", "CallBacks", { shiftId: shiftId }), 400, 600, { afterClose: function () { shifts.refreshContent(); } });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (shifts.context.length > 0) {
        shifts.initializeDataTable();
        shifts.bindEvents();
    }
});